<?php

namespace VM\FrontBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use VM\AdminBundle\Services\ApiGetter;
use VM\AdminBundle\Services\SsoCommunication;
use VM\ApiBundle\Controller\AbstractController;
use FOS\RestBundle\Controller\Annotations\View;
use VM\ApiBundle\Entity\Round;

class DefaultController extends AbstractController
{
    public function indexAction()
    {
        if($this->get('security.context')->isGranted('ROLE_TEACHER') || $this->get('security.context')->isGranted('ROLE_TEACHER_CREATOR'))
        {
            return $this->redirect($this->generateUrl('vm_admin_homepage'));
        }

        try
        {
            $User = $this->getUser();
            $Round = $this->getApiGetter()->getUserActualRound($User);
            $Company = $this->getApiGetter()->getGroupCompanyOrFalse($User->getGroup());

            if($Round instanceof Round)
            {
                if($Company !== false && $Company->getCreatorCompleted())
                {
                    return $this->redirect($this->generateUrl('vm_front_control_panel'));
                }
            }
            else
            {
                throw new \Exception('Nie została rozpoczęta pierwsza runda przez nauczyciela');
            }

            $MarketSegment = $User->getGroup()->getUser()->getMarketSegment();

            if(empty($MarketSegment))
            {
                throw new \Exception('Nie został wybrany segment rynku przez nauczyciela');
            }

            $roundEnd = '';
            if(!empty($Round))
            {
                $nextRound = $this->getApiGetter()->getNextRound($User, $Round);
                if($nextRound)
                {
                    $roundEnd = $nextRound->getStartAt();
                    if($roundEnd)
                    {
                        $roundEnd = $roundEnd -> format("Y-m-d H:i:s");
                    }        
                }
            }

            $companyCreatorCompleted = $Company !== false ?
                $Company->getCreatorCompleted(): $Company;

            if(!$companyCreatorCompleted && $Round->getSequence() > 1)
            {
                throw new \Exception('Gra się już rozpoczęła, a Twoja firma nie została założona');
            }

            return $this->render('VMFrontBundle:Default:index.html.twig', array(
                'uId' => md5($User->getId() + $this->getRequest()->getSession()->has('user_sso_token')),
                'uName' => $User->getName() . ' ' . $User->getSurname(),
                'gId' => md5($User->getGroup()->getId()),
                'chatHost' => $this->get('service_container')->getParameter('chat_url'),
                'roundId' => (!empty($Round)) ? $Round->getId() : 0,
                'roundName' => (!empty($Round)) ? $Round->getName() : '',
                'roundEnd' => $roundEnd,
                'roundSequence' => $Round->getSequence()
            ));
        }
        catch(\Exception $Exception)
        {
            switch($Exception->getCode())
            {
                case 40000:
                    $this->getRequest()->getSession()->getFlashBag()->add('warning', 'Nie została zainicjowana pierwsza tura. Musisz poczekać aż nauczyciel rozpocznie pierwszą turę.');
                    break;
                default:
                    $this->getRequest()->getSession()->getFlashBag()->add('warning', $Exception->getMessage());
                    break;
            }
            return $this->redirect($this->generateUrl('vm_front_warning'));
        }
    }


    public function warningAction()
    {
        $warnings = $this->getRequest()->getSession()->getFlashBag()->get('warning');

        if(empty($warnings))
        {
            return $this->redirect($this->generateUrl('vm_front_homepage'));
        }

        return $this->render('VMFrontBundle:Default:warning.html.twig', array(
            'User' => $this->getUser(),
            'warnings' => $warnings
        ));
    }



    public function controlPanelAction()
    {
        try
        {
            if($this->get('security.context')->isGranted('ROLE_TEACHER'))
            {
                return $this->redirect($this->generateUrl('vm_admin_homepage'));
            }

            $User = $this->getUser();
            $Company = $this->getApiGetter()->getGroupCompanyOrFalse($User->getGroup());

            if(!$Company->getCreatorCompleted())
            {
                return $this->redirect($this->generateUrl('vm_front_homepage'));
            }

            $Round = $this->getApiGetter()->getUserActualRound($this->getUser());
            $Round = $this->getApiGetter()->getUserActualRound($User);

            $roundEnd = '';
            if(!empty($Round))
            {
                $nextRound = $this->getApiGetter()->getNextRound($User, $Round);
                if($nextRound)
                {
                    $roundEnd = $nextRound->getStartAt();
                    if($roundEnd)
                    {
                        $roundEnd = $roundEnd -> format("Y-m-d H:i:s");
                    }
                }
            }


            if($Company === false && $Round->getSequence() > 1)
            {
                throw new \Exception('Gra się już rozpoczęła, a Twoja firma nie została założona');
            }

            return $this->render('VMFrontBundle:Default:controlPanel.html.twig', array(
                'uId' => md5($User->getId() + $this->getRequest()->getSession()->has('user_sso_token')),
                'uName' => $User->getName() . ' ' . $User->getSurname(),
                'gId' => md5($User->getGroup()->getId()),
                'chatHost' => $this->get('service_container')->getParameter('chat_url'),
                'roundId' => (!empty($Round)) ? $Round->getId() : 0,
                'roundName' => (!empty($Round)) ? $Round->getName() : '',
                'roundEnd' => $roundEnd,
                'roundSequence' => $Round->getSequence()
            ));
        }
        catch(\Exception $Exception)
        {
            $this->getRequest()->getSession()->getFlashBag()->add('warning', $Exception->getMessage());
            return $this->redirect($this->generateUrl('vm_front_warning'));
        }
	}

    public function creatorAction()
    {
        return $this->render('VMFrontBundle:Creator:creator.html.twig');
    }


    public function registrationConfirmAction($email, $token)
    {
        try
        {
            if($this->getRequest()->getMethod() == "POST")
            {
                $ApiGetter = $this->getApiGetter();
                $User = $ApiGetter->getUserByEmail($email);

                $Request = $this->getRequest()->request;
                $password = $Request->get('password');
                $passwordRetype = $Request->get('password_retype');
                if(empty($password) || ($password != $passwordRetype))
                {
                    throw new \Exception('Hasła nie są identyczne lub pole jest puste', 300);
                }

                $SsoCommunication = $this->getSsoCommunication();
                $result = $SsoCommunication->userChangePassword($User->getEmail(), $token, md5($password));


                if(strpos($this->getRequest()->getRequestUri(), '/register/password_change') !== false)
                {
                    $this->getRequest()->getSession()->getFlashBag()->add('success', 'Hasło zostało zmienione. Spróbuj zalogować się ponownie');
                }
                else
                {
                    $this->getRequest()->getSession()->getFlashBag()->add('success', 'Rejestracja została potwierdzona. Hasło zostało ustawione');
                }
                return $this->redirect($this->generateUrl('vm_front_homepage'));
            }
        }
        catch(\Exception $Exception)
        {
            $message = $Exception->getMessage();
            switch($Exception->getCode())
            {
                case 0:
                    $message = 'Użytkownik nie istnieje';
                    break;
                case 300:
                    $message = $Exception->getMessage();
                    break;
                case 20005:
                    $message = 'Nieprawidłowy kod autoryzacyjny';
                    break;
                default:
                    $message = 'Błąd wewnętrzny SSO';
                    break;
            }
            $this->getRequest()->getSession()->getFlashBag()->add('error', $message);
        }

        if(strpos($this->getRequest()->getRequestUri(), '/register/password_change') !== false)
        {
            return $this->render('VMFrontBundle:Registration:password_change.html.twig', array(
                'email' => $email,
                'token' => $token
            ));
        }
        else
        {
            return $this->render('VMFrontBundle:Registration:confirm.html.twig', array(
                'email' => $email,
                'token' => $token
            ));
        }
    }


    /**
     * @View()
     */
    public function spentTimeAction()
    {
        if($this->getRequest()->getMethod() == 'POST')
        {
            if(!$this->getRequest()->getSession()->has('user_sso_token'))
            {
                return false;
            }
            else
            {
                return true;
            }
        }
        else
        {
            return $this->redirect($this->generateUrl('vm_front_homepage'));
        }
    }

    public function passwordRecoveryAction()
    {

        if($this->get('security.context')->isGranted('ROLE_USER'))
        {
            return $this->redirect($this->generateUrl('vm_front_homepage'));
        }
        else
        {
            if($this->getRequest()->getMethod() == 'POST')
            {
                $email = $this->getRequest()->request->get('email');
                $SsoCommunication = $this->getSsoCommunication();
                try{
                    $User = $this->getApiGetter()->getUserByEmail($email);
                    $result = $SsoCommunication->userGeneratePasswordRecoveryToken($email);

                    $message = \Swift_Message::newInstance()
                        ->setSubject('Rejestracja w Grze Biznesowej')
                        ->setFrom('grabiznesowa@vm.pl')
                        ->setTo($User->getEmail())
                        ->setBody(
                            $this->renderView(
                                'VMAdminBundle:Mailer:password_recovery_email.html.twig',
                                array(
                                    'User' => $User,
                                    'result' => $result
                                )
                            )
                        )
                    ;
                    $this->get('mailer')->send($message);
                    $this->getRequest()->getSession()->getFlashBag()->add('success', 'Na podany adres został wysłany <br/>e-mail z dalszymi instrukcjami');
                }
                catch(\Exception $Exception)
                {
                    $this->getRequest()->getSession()->getFlashBag()->add('error', 'Nieprawidłowy adres e-mail');
                }
            }


            return $this->render('VMFrontBundle:Security:password_recovery.html.twig', array(
                'error' => array()
            ));
        }
    }

    /**
     * @return ApiGetter
     */
    protected function getApiGetter()
    {
        return $this->get('vm_admin.api.getter');
    }

    /**
     * @return SsoCommunication
     */
    protected function getSsoCommunication()
    {
        return $this->get('vm_admin.sso.communication');
    }
}
